/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_758;
import ru.bclib.util.BackgroundInfo;
import ru.bclib.util.MHelper;
import ru.betterend.BetterEnd;

public class BetterEndSkyRenderer
implements DimensionRenderingRegistry.SkyRenderer {
    private static final class_2960 NEBULA_1 = BetterEnd.makeID("textures/sky/nebula_2.png");
    private static final class_2960 NEBULA_2 = BetterEnd.makeID("textures/sky/nebula_3.png");
    private static final class_2960 HORIZON = BetterEnd.makeID("textures/sky/nebula_1.png");
    private static final class_2960 STARS = BetterEnd.makeID("textures/sky/stars.png");
    private static final class_2960 FOG = BetterEnd.makeID("textures/sky/fog.png");
    private class_291 nebula1;
    private class_291 nebula2;
    private class_291 horizon;
    private class_291 stars1;
    private class_291 stars2;
    private class_291 stars3;
    private class_291 stars4;
    private class_291 fog;
    private class_1160 axis1;
    private class_1160 axis2;
    private class_1160 axis3;
    private class_1160 axis4;
    private boolean initialised;

    private void initialise() {
        if (!this.initialised) {
            this.initStars();
            Random random = new Random(131L);
            this.axis1 = new class_1160(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis2 = new class_1160(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis3 = new class_1160(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis4 = new class_1160(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis1.method_4952();
            this.axis2.method_4952();
            this.axis3.method_4952();
            this.axis4.method_4952();
            this.initialised = true;
        }
    }

    public void render(WorldRenderContext context) {
        float a;
        if (context.world() == null || context.matrixStack() == null) {
            return;
        }
        this.initialise();
        class_1159 projectionMatrix = context.projectionMatrix();
        class_4587 matrices = context.matrixStack();
        float time = ((float)context.world().method_8532() + context.tickDelta()) % 360000.0f * 1.7453292E-5f;
        float time2 = time * 2.0f;
        float time3 = time * 3.0f;
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        float blindA = 1.0f - BackgroundInfo.blindness;
        float blind02 = blindA * 0.2f;
        float blind06 = blindA * 0.6f;
        if (blindA > 0.0f) {
            matrices.method_22903();
            matrices.method_22907(new class_1158(0.0f, time, 0.0f, false));
            RenderSystem.setShaderTexture((int)0, (class_2960)HORIZON);
            this.renderBuffer(matrices, projectionMatrix, this.horizon, class_290.field_1585, 0.77f, 0.31f, 0.73f, 0.7f * blindA);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(new class_1158(0.0f, -time, 0.0f, false));
            RenderSystem.setShaderTexture((int)0, (class_2960)NEBULA_1);
            this.renderBuffer(matrices, projectionMatrix, this.nebula1, class_290.field_1585, 0.77f, 0.31f, 0.73f, blind02);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(new class_1158(0.0f, time2, 0.0f, false));
            RenderSystem.setShaderTexture((int)0, (class_2960)NEBULA_2);
            this.renderBuffer(matrices, projectionMatrix, this.nebula2, class_290.field_1585, 0.77f, 0.31f, 0.73f, blind02);
            matrices.method_22909();
            RenderSystem.setShaderTexture((int)0, (class_2960)STARS);
            matrices.method_22903();
            matrices.method_22907(this.axis3.method_23626(time));
            this.renderBuffer(matrices, projectionMatrix, this.stars3, class_290.field_1585, 0.77f, 0.31f, 0.73f, blind06);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(this.axis4.method_23626(time2));
            this.renderBuffer(matrices, projectionMatrix, this.stars4, class_290.field_1585, 1.0f, 1.0f, 1.0f, blind06);
            matrices.method_22909();
        }
        if ((a = BackgroundInfo.fogDensity - 1.0f) > 0.0f) {
            if (a > 1.0f) {
                a = 1.0f;
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)FOG);
            this.renderBuffer(matrices, projectionMatrix, this.fog, class_290.field_1585, BackgroundInfo.fogColorRed, BackgroundInfo.fogColorGreen, BackgroundInfo.fogColorBlue, a);
        }
        RenderSystem.disableTexture();
        if (blindA > 0.0f) {
            matrices.method_22903();
            matrices.method_22907(this.axis1.method_23626(time3));
            this.renderBuffer(matrices, projectionMatrix, this.stars1, class_290.field_1592, 1.0f, 1.0f, 1.0f, blind06);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(this.axis2.method_23626(time2));
            this.renderBuffer(matrices, projectionMatrix, this.stars2, class_290.field_1592, 0.95f, 0.64f, 0.93f, blind06);
            matrices.method_22909();
        }
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void renderBuffer(class_4587 matrices, class_1159 matrix4f, class_291 buffer, class_293 format, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        if (format == class_290.field_1592) {
            buffer.method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34539());
        } else {
            buffer.method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34542());
        }
    }

    private void initStars() {
        class_287 buffer = class_289.method_1348().method_1349();
        this.stars1 = this.buildBufferStars(buffer, this.stars1, 0.1, 0.3, 3500, 41315L);
        this.stars2 = this.buildBufferStars(buffer, this.stars2, 0.1, 0.35, 2000, 35151L);
        this.stars3 = this.buildBufferUVStars(buffer, this.stars3, 0.4, 1.2, 1000, 61354L);
        this.stars4 = this.buildBufferUVStars(buffer, this.stars4, 0.4, 1.2, 1000, 61355L);
        this.nebula1 = this.buildBufferFarFog(buffer, this.nebula1, 40.0, 60.0, 30, 11515L);
        this.nebula2 = this.buildBufferFarFog(buffer, this.nebula2, 40.0, 60.0, 10, 14151L);
        this.horizon = this.buildBufferHorizon(buffer, this.horizon);
        this.fog = this.buildBufferFog(buffer, this.fog);
    }

    private class_291 buildBufferStars(class_287 bufferBuilder, class_291 buffer, double minSize, double maxSize, int count, long seed) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new class_291();
        this.makeStars(bufferBuilder, minSize, maxSize, count, seed);
        bufferBuilder.method_1326();
        buffer.method_1352(bufferBuilder);
        return buffer;
    }

    private class_291 buildBufferUVStars(class_287 bufferBuilder, class_291 buffer, double minSize, double maxSize, int count, long seed) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new class_291();
        this.makeUVStars(bufferBuilder, minSize, maxSize, count, seed);
        bufferBuilder.method_1326();
        buffer.method_1352(bufferBuilder);
        return buffer;
    }

    private class_291 buildBufferFarFog(class_287 bufferBuilder, class_291 buffer, double minSize, double maxSize, int count, long seed) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new class_291();
        this.makeFarFog(bufferBuilder, minSize, maxSize, count, seed);
        bufferBuilder.method_1326();
        buffer.method_1352(bufferBuilder);
        return buffer;
    }

    private class_291 buildBufferHorizon(class_287 bufferBuilder, class_291 buffer) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new class_291();
        this.makeCylinder(bufferBuilder, 16, 50.0, 100.0);
        bufferBuilder.method_1326();
        buffer.method_1352(bufferBuilder);
        return buffer;
    }

    private class_291 buildBufferFog(class_287 bufferBuilder, class_291 buffer) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new class_291();
        this.makeCylinder(bufferBuilder, 16, 50.0, 70.0);
        bufferBuilder.method_1326();
        buffer.method_1352(bufferBuilder);
        return buffer;
    }

    private void makeStars(class_287 buffer, double minSize, double maxSize, int count, long seed) {
        Random random = new Random(seed);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() * 2.0 - 1.0;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = MHelper.randRange((double)minSize, (double)maxSize, (Random)random);
            double length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = 1.0 / Math.sqrt(length);
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.nextDouble() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_1344();
            }
        }
    }

    private void makeUVStars(class_287 buffer, double minSize, double maxSize, int count, long seed) {
        Random random = new Random(seed);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() * 2.0 - 1.0;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = MHelper.randRange((double)minSize, (double)maxSize, (Random)random);
            double length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = 1.0 / Math.sqrt(length);
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.nextDouble() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            float minV = (float)random.nextInt(4) / 4.0f;
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = (float)(index + 1 >> 1 & 1) / 4.0f + minV;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_22913(texU, texV).method_1344();
            }
        }
    }

    private void makeFarFog(class_287 buffer, double minSize, double maxSize, int count, long seed) {
        Random random = new Random(seed);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() - 0.5;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = MHelper.randRange((double)minSize, (double)maxSize, (Random)random);
            double length = posX * posX + posY * posY + posZ * posZ;
            double distance = 2.0;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = distance / Math.sqrt(length);
            size *= distance;
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.nextDouble() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = index + 1 >> 1 & 1;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_22913(texU, texV).method_1344();
            }
        }
    }

    private void makeCylinder(class_287 buffer, int segments, double height, double radius) {
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < segments; ++i) {
            double a1 = (double)i * Math.PI * 2.0 / (double)segments;
            double a2 = (double)(i + 1) * Math.PI * 2.0 / (double)segments;
            double px1 = Math.sin(a1) * radius;
            double pz1 = Math.cos(a1) * radius;
            double px2 = Math.sin(a2) * radius;
            double pz2 = Math.cos(a2) * radius;
            float u0 = (float)i / (float)segments;
            float u1 = (float)(i + 1) / (float)segments;
            buffer.method_22912(px1, -height, pz1).method_22913(u0, 0.0f).method_1344();
            buffer.method_22912(px1, height, pz1).method_22913(u0, 1.0f).method_1344();
            buffer.method_22912(px2, height, pz2).method_22913(u1, 1.0f).method_1344();
            buffer.method_22912(px2, -height, pz2).method_22913(u1, 0.0f).method_1344();
        }
    }
}

